#! /bin/bash
# loop for testing the SDMP
r_idx=0
for ((out_idx=0; out_idx<${#TEST_config_name[@]}; ++out_idx)); do
    for dict_folder in ${SDMP_root_result_path}/*; do
        data_time=`date +"%Y-%m-%d %T" | sed -r 's/ /_/g'`
        cur_result_path=${host_name}_${data_time}
        set -x
        taskset -c ${cpu_list[$r_idx]} python ../main_test_SDMP.py --data ../dataset --dict $dict_folder --config ${TEST_config_root}/${TEST_config_name[$out_idx]} --device "cuda:${gpu_list[$r_idx]}" --result "${TEST_root_result_path}/${cur_result_path}" --gnn $GNN_target_path> /dev/null &
        pids[$idx]=$!
        set +x
        sleep 2

        r_idx=$((r_idx+1))
        if [ $r_idx -ge $pool_size ];then
            for pid in ${pids[*]}; do
                wait $pid
            done
        r_idx=0
        fi
    done
done

for pid in ${pids[*]}; do
    wait $pid
done
